---
mindmap-plugin: basic
---

# 高等数学

## 微分学

### 一元函数微分学
- 函数
    - 函数的概念
        - 函数定义：
                           如果对于每个数 $x\in D$ ，变量 $x$ 按照一定的法则总有一个确定的 $y$ 和它对应，则称 $x$ 是 $y$ 的函数，记为 $y=f(x)$；常称 x 为自变量，$y$ 为因变量，$D$ 为定义域.
        - 复合函数：
                           设 $y=f(u)$ 的定义域为 $D_f，u=g(x)$ 的定义域为 $D_g$ 、值域为 $R_{s}$ ；若 $D_f\cap R_g\neq\phi,\text{则称函数}y=f[g(x)]$ 为函数 $y=f(u)$ 与 $u=g(x)$ 的复合函数. 它的定义域为 $\left\{x|x\in D_g,g(x)\in D_f\right\}$
        - 反函数：
                           设函数 $y=f(x)$ 的定义域为 ${D}$, 值域为 $\underline{R}_{\underline{\nu}}$.若对任意 $y\in R_y$ ,有唯一确定的 $x\in D$ ,使得 $y=f(x)$,则记为 $x=f^{-1}(y)$ 称其为函数 $y=f(x)$ 的反函数
    - 函数的性质
        - 单调性
        - 奇偶性：
            - 常见奇函数：$\sin x,\tan x,\arcsin x,\arctan x,\ln\frac{1-x}{1+x},{\ln(x+\sqrt{1+x^2})},\frac{e^x-1}{e^x+1},$$f(-x)=-f(x)$
            - 常见偶函数：$x^2,|x|,\cos x,f(x)=f(-x)$
        - 周期性
        - 有界性
- 极限
    - 极限的性质
        - 数列极限性质
            - 有界性：$\text{如果数列 }\left\{x_n\right\}\text{收敛,那么数列 }\left\{x_n\right\}\text{一定有界}$
            - 保号性；
        - 函数极限性质
            - 局部有界性：$\text{若 }\lim_{x\to x_0}f(x)\text{ 存在,则 }f(x)\text{ 在 }x_0\text{ 某去心邻域}$
            - 保号性
    - 函数极限
        - 函数趋向于无限值
            - 函数与无穷：
                              $\lim_{x \to \infty}f(x) = A \Leftrightarrow \forall \xi >0,\exists X>0,\lvert x \rvert >X \ \mbox{时有},\lvert f(x) - A\rvert < \xi$
            - 函数趋向于负无穷：
                               $\lim_{x\to-\infty}f(x)=A$： $\forall\boldsymbol{\varepsilon}>\boldsymbol{0},\exists\boldsymbol{X}>\boldsymbol{0},\boldsymbol{当}x<\boldsymbol{-X}\text{时,恒有}|f(x)-A|<\varepsilon.$
            - 函数趋向于正无穷：
                               $\lim_{x\to+\infty}f(x)=A$： $\forall\boldsymbol{\varepsilon}>\boldsymbol{0},\exists\boldsymbol{X}>\boldsymbol{0},\boldsymbol{当}x>\boldsymbol{X}\text{时,恒有}|f(x)-A|<\varepsilon.$
        - 函数趋向于有限值
            - ${\lim_{x\to x_0}f(x)=A}$，$\forall\varepsilon>0,\exists\delta>0\text{,当 }0<|x-x_0|<\delta\text{ 时,恒有 }|f(x)-A|<\varepsilon.$
        - 单侧极限
            - 左极限：$\lim_{x \to x_{0}^{-}}f(x) = A \Leftrightarrow\begin{cases} \hspace{1em} \forall \xi >0,\exists \delta>0,x_{0}-\delta <x<x_{0} \ \mbox{时有},\\ \hspace{1em} \lvert f(x) - A\rvert < \xi \\ \end{cases}$
            - 右极限：$\lim_{x \to x_{0}^{+}}f(x) = A \Leftrightarrow\begin{cases} \hspace{1em} \forall \xi >0,\exists \delta>0,x_{0}<x<x_{0}+\delta \ \mbox{时有},\\ \hspace{1em} \lvert f(x) - A\rvert < \xi \\ \end{cases}$
            - 极限与单侧极限关系：
                             $\lim_{x\to x_0}f(x)=A\Leftrightarrow\lim_{x\to x_0^-}f(x)=\lim_{x\to x_0^+}f(x)=A$
    - 数列极限
        - 数列极限的定义：
                          对 $\lim_{n\to\infty}x_n=a$ 而言：$\forall\varepsilon>0,\exists N>0,\text{ 当 }n>N\text{ 时, 恒有 }|x_n-a|<\varepsilon$
        - 数列极限存在准则：
                          $\text{若存在 }N,\text{当 }n>N\text{ 时, }x_n\leq y_n\leq z_n$，$\lim_{n\to\infty}x_n=\lim_{n\to\infty}z_n=a,\text{则}\lim_{n\to\infty}y_n=a$
    - 求极限
        - 求极限八种方法
    - 无穷大与无穷小
        - 无穷小
            - 无穷小的定义：若函数 $f(x)$ 当 $x\to x_0($ 或 $x\to\infty)$ 时的极限为零，则称 $f(x)$ 为 $x\to x_0($ 或 $x\to\infty)$ 时的无穷小量.
            - 无穷小的比较：
                - **同阶**无穷小： $\alpha(x)和\beta(x)$ 相除结果为**常数 C**（C 不等于 0）；
                - **等价**无穷小： $\alpha(x)和\beta(x)$ 相除结果为**常数 1**；
                - 高阶无穷小： $\alpha(x)和\beta(x)$ 相除结果为 0；可记为：$\alpha(x)=o(\beta(x))$
                - 低阶无穷小： $\alpha(x)和\beta(x)$ 相除结果为无穷；
                - $\text{若}\lim\frac{\alpha (x)^{\color{red}{}}}{\left[\beta (x)\right]^{k}\color{red}}=C\neq 0,\text{称}$ α为β的 k 阶无穷小；
            - 无穷小的性质：
                - **性质 1：** **有限**个无穷小的和仍然是无穷小；
                - **性质 2：** **有限**个无穷小的积仍然是无穷小；
                - **性质 3：** 无穷小量与**有界量**的**积**任然是无穷小；
        - 无穷大
            - 无穷大的定义：
                            若函数 $f(x)$ 当 $x\to x_0($ 或 $x\to\infty)$ 时的极限无穷，则称 $f(x)$ 为 $x\to x_0($ 或 $x\to\infty)$ 时的无穷大量.
            - 无穷大的性质：
                - **性质 1：** 有限个正无穷大的和是无穷大；
                - **性质 2：** 有限个无穷大的**积**仍然是无穷大；
                - **性质 3：** 无穷大量与有界变量的和仍然是无穷大量；
- 连续
    - 连续的定义
        - 左连续
        - 右连续
        - 定义：
                       设函数 $y=f(x)$ 在点 $x_{0}$ 的某个邻域内有定义，如果当 $x\to x_0$ 时，函数 $y=f(x)$ 的极限值存在，且等于 $x_{0}$ 处的函数值 $f(x_0)$ , 即 $\lim_{x\to x_0}f(x)=f(x_0)$, 则称函数 $y=f(x)$ 在点 $x_{0}$ 处连续.
    - 连续性的性质
        - 闭区间上连续性的函数性质：
            - 有界性：$\text{若 f(x) 在 [a,b]上连续,则 f(x) 在 [a,b]上有界。}$
            - 最值定理：若 $f(x)$ 在 $[a,b]$ 上连续，则 $f(x)$ 在 $[a,b]$ 上必有最大值和最小值；
            - 介值定理：若 $f(x)$ 在 $[a,b]$ 上连续，且 $f(a)\neq f(b)$,则对 $f(a)$ 与 $f(b)$ 中 $\text{之间任一数}\mathbf{C},\text{ 至少存在一个 }\xi\in(a,b),\text{ 使得 }f(\xi){=}C.$
            - 零点定理
        - 连续性的运算性质
    - 间断点
        - 间断点的定义：
        - 几类间断点
- 导数
    - 导数的定义
        - 什么是导数
        - 左导数与右导数
        - 导函数的几何意义
    - 导数求导法则
        - 和差积商求导法则
        - 反函数求导法则
        - 复合函数求导法则
        - 求导常用结论
        - 对数求导法
    - 高阶导数
        - 高阶导数的定义
        - 常见求高阶导数公式
    - 隐函数
    - 参数方程
    - 导数应用
        - 函数单调性的判读
        - 凹凸性的判断
        - 拐点
        - 函数的极值与最值
        - 渐近线
            - 水平渐近线
            - 垂直渐近线
            - 新节点
- 微分
    - 微分的定义：
        - $\text{若 }f(x_0+\Delta x)-f(x_0)=A\Delta x+o(\Delta x)\text{ ，则称 }f(x)$ $在 x _0点可微；$
    - 可微、可导、连续之间关系
        - ![[Pasted image 20240317192744.png]]
    - 微分中值定理
        - 罗尔定理：
            - 若满足三个条件：
            - 1）$f$ 在 $[a,b]$ 上连续；
            - 2）$f$ 在 $(a,b)$ 内可导；
            - 3）f (a)=f (b)
            - 则可知：$\text{则 }\exists\xi\in(a,b)\text{,使 }f^{\prime}(\xi)=0$
            - 推导结论：有一点的切线，和 ab 两点的连线平行 `->` 拉格朗日定理；
        - 拉格朗日中值定理：
            - 若满足以下几个条件： 1）$f$ 在 $[a,b]$ 上连续 2）$f$ 在 ($a,b)$ 内可导；
            - 则：$\text{可得 }\exists\xi\in(a,b)\text{,使 }f(b)-f(a)=f^{\prime}(\xi)(b-a)$
        - 柯西中值定理：
            - 若满足以下条件：
            - 1）$f,F\text{ 在 }[a,b]\text{上连续};$
            - 2）$f,F\text{ 在 }(a,b)\text{ 内可导,且 }\forall x\in(a,b),F^{\prime}(x)\neq0$
            - 则：$\exists\xi\in(a,b)\text{ ,使 }\frac{f(b)-f(a)}{F(b)-F(a)}=\frac{f^{\prime}(\xi)}{F^{\prime}(\xi)}$

### 多元函数微分学
- 多元函数基本概念
    - 多元函数的极限
    - 多元函数的连续
    - 偏导数
        - 偏导数的定义
        - 偏导数的几何意义
        - 高阶偏导数
    - 全微分
        - 全微分的定义
        - 多元函数可微分的必要条件
        - 多元函数可微分的充分条件
    - 多元函数分析
        - 可微、可导、连续、偏导连续的判断
        - 可微、可导、连续、偏导连续之间关系
- 多元函数微分法
    - 多元复合函数微分
        - 多元复合函数求导法则
        - 全微分形式不变性
    - 多元隐函数微分
        - 多元函数隐函数定义
        - 多元函数隐函数存在定理
- 多元函数的极值与最值
    - 多元函数极值定义
        - 多元函数极值存在的必要条件
    - 无条件极值
    - 有条件极值
        - 拉格朗日乘数法
        - 条件极值定义

## 积分学

### 一元函数积分学
- 不定积分
    - 不定积分的概念
        - 不定积分的定义：
                      一个函数 $f(x)$ 的不定积分（或者说是原函数）是一个导数等于 $f(x)$ 的函数 $F(x)$ ，即 F′(x) = f (x)，或写成 $[F (x)+c]^{\prime}=f (x)$
                      或者：$\int f(x)dx=F(x)+C$
        - 原函数存在性：
    - 不定积分基本性质
        - $(\int f(x)\mathrm{d}x)^{\prime}=f(x)$
        - $\mathrm{d}\int f(x)\mathrm{d}x=f(x)\mathrm{d}x$
    - 不定积分的计算
        - 基本公式
        - 第一类换元法
        - 第二类换元法
        - 分部积分法
- 定积分
    - 定积分的概念
        - 定积分的定义：
                      $f(x)$ 在 $[a,b]$ 上有界，在 $[a,b]$ 上任意插入分点，分成 n 个小区间 $\Delta x_{1}\Delta x_{2}\cdots\Delta x_{n}$ ，任取一点 i，有：$$\int_{a}^{b}f(x)dx=\lim_{λ\to0}\sum_{x=1}^{n}f(\xi_{i})\Delta x_{i}$$
            - 其中：$$\lambda=\max\{\Delta x_{1}\cdots\Delta x_{n}\}$$
        - 微积分基本定理
    - 定积分的计算
        - 牛顿-莱布尼茨公式
        - 定积分的换元法
        - 定积分的分部积分法
        - 定积分性质
    - 变上限积分
        - 方法一：公式计算
        - 方法二：提取x
        - 方法三：换元法
    - 反常积分
        - 反常积分的定义
        - 两类反常积分
            - 无穷区间上的反常积分
            - 无穷函数上的反常积分
        - 判断反常积分的敛散性
            - 方法一：定义法
            - 方法二：比较判别法
            - 方法三：P积分
    - 定积分的应用
        - 平面图形的面积
        - 旋转体的体积
        - 平面曲线的弧长
        - 旋转体侧面积
        - 新节点

### 多元函数积分学
- 重积分
    - 二重积分
        - 二重积分的定义
        - 二重积分的性质
        - 二重积分的计算
            - 基于直角坐标系的二重积分计算
            - 基于极坐标系的二重积分计算
            - 利用奇偶性、对称性
    - 三重积分
- 线面积分
    - 线积分
    - 面积分
- 积分应用

## 微分方程

### 一阶微分方程
- 可分离变量
- 一阶齐次方程
- 一阶线性方程

### 二阶微分方程
- 二阶常系数齐次微分方程
- 二阶常系数非齐次微分方程

### 高阶微分方程
- 可降阶线性微分方程
- 高阶微分方程概念

## 无穷级数

### 常数项级数
- 基础概念
    - 常数项级数的定义
    - 常数项级数收敛的定义：$\lim_{n\to+\infty}S_{n}=\sum_{n=1}^\infty u_n$
    - 级数基本性质
- 同号级数
    - 正项级数
        - 正项级数收敛性：$\sum_{n=1}^\infty u_n\text{ 收敛}\Leftrightarrow s_n\text{ 上有界}$
        - 比较审敛法
        - 比较法的极限形式
        - 比值法
        - 根值法
        - 积分判别法
- 变号级数
    - 交错级数
        - 交错级数定义：$\sum_{n=1}^\infty(-1)^{n-1}u_n,u_n>0$
        - 莱布尼茨准则
    - 任意项级数
        - 绝对收敛与条件收敛概念
        - 任意项级数收敛性判断

### 幂级数
- 幂级数基础概念
    - 幂级数的定义
        - $\sum_{n=0}^\infty a_n(x-x_0)^n=a_0+a_1(x-x_0)+\cdots+a_n(x-x_0)^n+\cdots$
    - 幂级数的收敛性
        - 收敛点与发散点的概念
        - 阿贝尔定理
        - 收敛区间
        - 收敛域
    - 收敛半径
        - 收敛半径判断法一：极限比值
        - 收敛半径判断法二：基于根式
    - 幂级数的运算
        - 有理运算性质
        - 分析性质
- 函数展开成幂级数
    - 基础概念
        - 函数的幂级数展开
        - 泰勒级数的收敛性
    - 函数展开为幂级数
        - 直接展开法
        - 间接展开法
    - 常见展开

### 傅里叶级数
- 傅里叶级数基础概念
    - 傅里叶系数
    - 傅里叶级数
    - 收敛性
        - 狄利克雷定理
- 函数展开为傅里叶级数
    - 周期函数的展开：特殊情况
    - 周期函数的展开：一般情况

## 空间解析几何

### 向量代数

### 空间平面与直线

### 曲面与空间曲线

### 多元微分在几何中的应用